<?php
/**
 * Template part for displaying Recent Posts in the front page template
 *
 * @package WEN_Travel
 */

if ( ! ( 'page' == get_option( 'show_on_front' ) && is_front_page() && get_theme_mod( 'wen_travel_enable_static_page_posts' ) ) )  {
	return;
}
?>
<div class="recent-blog-content archive-posts-wrapper section">
	<div class="wrapper">
		<?php
		$post_title = get_theme_mod( 'wen_travel_recent_posts_heading', esc_html__( 'Recent Posts', 'wen-travel-pro' ) );

		if ( '' !== $post_title ) :
		?>
			<div class="section-heading-wrapper">
				<h2 class="section-title"><?php echo esc_html( $post_title ); ?></h2>
			</div><!-- .section-heading-wrap -->
		<?php
		endif;
		?>
		<div class="section-content-wrapper recent-blog-content-wrapper">
			<div id="infinite-post-wrap" class="archive-post-wrap">
				<?php
				$recent_posts = new WP_Query( array(
					'ignore_sticky_posts' => true,
				) );

				/* Start the Loop */
				while ( $recent_posts->have_posts() ) :
					$recent_posts->the_post();
					?>
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="post-wrapper hentry-inner">
							<?php wen_travel_archive_image(); ?>

							<div class="entry-container">

								<header class="entry-header">
									<?php if ( is_sticky() ) { ?>
										<span class="sticky-post"><?php esc_html_e( 'Featured', 'wen-travel-pro' ); ?></span>
									<?php } ?>

									<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

									<?php if ( 'post' === get_post_type() ) : ?>
									<div class="entry-meta">
										<?php wen_travel_posted_on(); ?>
									</div><!-- .entry-meta -->
									<?php
									endif; ?>
								</header><!-- .entry-header -->

								<div class="entry-content">
									<?php
									$archive_layout = get_theme_mod( 'wen_travel_content_layout', 'excerpt' );

									if ( 'full-content-custom' === $archive_layout || 'full-content' === $archive_layout ) {
										/* translators: %s: Name of current post. Only visible to screen readers */
										the_content( sprintf(
											wp_kses(

												__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'wen-travel-pro' ),
												array(
													'span' => array(
														'class' => array(),
													),
												)
											),
											get_the_title()
										) );

										wp_link_pages( array(
											'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'wen-travel-pro' ),
											'after'  => '</div>',
										) );
									} else {
										the_excerpt();
									}
									?>
								</div><!-- .entry-content -->
							</div> <!-- .entry-container -->
						</div><!-- .hentry-inner -->
					</article><!-- #post -->
					<?php
				endwhile;

				wp_reset_postdata();
				?>
			</div><!-- .archive-post-wrap -->
		</div><!-- .section-content-wrap -->
		<p class="view-more"><a class="more-recent-posts button" href="<?php the_permalink( get_option( 'page_for_posts' ) ); ?>"><?php esc_html_e( 'More Posts', 'wen-travel-pro' ); ?></a></p>
	</div> <!-- .wrapper -->
</div> <!-- .recent-blog-content-wrapper -->
