<?php
/**
 * The template for displaying service image content
 *
 * @package WEN_Travel
 */
?>

<?php
$quantity = get_theme_mod( 'wen_travel_service_number', 6 );
$no_thumb = trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'images/no-thumb-80x80.jpg';

for ( $i = 1; $i <= $quantity; $i++ ) {
	$target = get_theme_mod( 'wen_travel_service_target_' . $i ) ? '_blank' : '_self';

	$wen_travel_link = get_theme_mod( 'wen_travel_service_link_' . $i ) ? get_theme_mod( 'wen_travel_service_link_' . $i ) : '#';

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	echo '
	<article id="service-post-' . esc_attr( $i ) . '" class="hentry"> <div class="hentry-inner">';

		$wen_travel_title   = get_theme_mod( 'wen_travel_service_title_' . $i );
		$content = get_theme_mod( 'wen_travel_service_content_' . $i );
		$more_button = get_theme_mod( 'wen_travel_service_more_button_text_' . $i );

		$image = get_theme_mod( 'wen_travel_service_image_' . $i ) ? get_theme_mod( 'wen_travel_service_image_' . $i ) : '';

		if ( $image ) {
			echo '
			<div class="post-thumbnail">
			<a href="' . esc_url( $wen_travel_link ) . '" target="' . esc_attr( $target ) . '">
				<img src="' . esc_url( $image ) . '" class="wp-post-image" alt="' . esc_attr( $wen_travel_title ) . '" title="' . esc_attr( $wen_travel_title ) . '">
			</a></div>';
		} else {
			echo '
			<div class="post-thumbnail">
			<a href="' . esc_url( $wen_travel_link ) . '" target="' . esc_attr( $target ) . '">
				<img src="' . esc_url( $no_thumb ) . '" class="wp-post-image" alt="' . esc_attr( $wen_travel_title ) . '" title="' . esc_attr( $wen_travel_title ) . '">
			</a></div>';
		}
		

		if ( $wen_travel_title || $content || $more_button) {
			echo '
			<div class="entry-container">
				<header class="entry-header">';

				if ( $wen_travel_title ) {
					echo '
					<h2 class="entry-title">
						<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . wp_kses_post( $wen_travel_title ) . '</a>
					</h2>';
				}

				echo '</header>';

				if ( $content || $more_button ) {
					if ( $more_button ) {
						$content .= '<span class="more-button">
							<a class="more-link" href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . esc_html( $more_button ) . '</a>
						</span>';
					}

				 	echo '<div class="entry-summary">' . wp_kses_post( apply_filters( 'the_content', $content ) ) . '</div><!-- .entry-summary -->';
				}



				echo '
			</div><!-- .entry-container -->';
		}

		echo '
		</div>
	</article><!-- .service-post-' . esc_attr( $i ) . ' -->';
} // End for().
