<?php
/**
 * The template for displaying service posts on the front page
 *
 * @package WEN_Travel
 */

$show_content  = get_theme_mod( 'wen_travel_service_show', 'excerpt' );
$show_meta     = get_theme_mod( 'wen_travel_service_meta_show', 'hide-meta' );
$wen_travel_type = get_theme_mod( 'wen_travel_service_type', 'category' );
$number        = get_theme_mod( 'wen_travel_service_number', 6 );

$post_list  = array();
$no_of_post = 0;

$args = array(
	'post_type'           => 'post',
	'ignore_sticky_posts' => 1, // ignore sticky posts.
);

// Get valid number of posts.
if ( 'post' === $wen_travel_type || 'page' === $wen_travel_type || 'ect-service' === $wen_travel_type ) {
	$args['post_type'] = $wen_travel_type;

	for ( $i = 1; $i <= $number; $i++ ) {
		$wen_travel_post_id = '';

		if ( 'post' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_service_post_' . $i );
		} elseif ( 'page' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_service_page_' . $i );
		} elseif ( 'ect-service' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_service_cpt_' . $i );
		}

		if ( $wen_travel_post_id ) {
			$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

			$no_of_post++;
		}
	}

	$args['post__in'] = $post_list;
	$args['orderby']  = 'post__in';
} elseif ( 'category' === $wen_travel_type ) {
	if ( $wen_travel_cat = get_theme_mod( 'wen_travel_service_select_category' ) ) {
		$args['category__in'] = $wen_travel_cat;
	}

	$no_of_post = $number;
}

$args['posts_per_page'] = $no_of_post;

if ( ! $no_of_post ) {
	return;
}

$loop = new WP_Query( $args );

while ( $loop->have_posts() ) :
	
	$loop->the_post();
	$no_thumb = trailingslashit( esc_url ( get_template_directory_uri() ) ) . 'images/no-thumb-80x80.jpg';
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="hentry-inner">
			<?php if( has_post_thumbnail() ) : ?>
				<div class="post-thumbnail">
					<a class="cover-link" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
						<img src="<?php the_post_thumbnail_url( 'wen-travel-stats' ); ?>">
					</a>
				</div>
			<?php else : ?>
				<div class="post-thumbnail">
					<a class="cover-link" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
						<img src="<?php echo esc_url( $no_thumb ); ?>">
					</a>
				</div>
			<?php endif; ?>

			<div class="entry-container">
				<header class="entry-header">
					<?php if ( 'show-meta' === $show_meta  && ( 'ect-service' == $wen_travel_type || 'post' === $wen_travel_type || 'category' === $wen_travel_type ) ) : ?>
						<div class="entry-category">
							<?php wen_travel_cat_list(); ?>
						</div>
					<?php endif; ?>
					<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">','</a></h2>' ); ?>

					<?php if ( 'show-meta' === $show_meta  && 'custom' !== $wen_travel_type ) : ?>
					<div class="entry-meta">
						<?php wen_travel_posted_on(); ?>
					</div><!-- .entry-meta -->
					<?php endif; ?>

				</header>

				<?php
				if ( 'excerpt' === $show_content ) {
					$excerpt = get_the_excerpt();

					echo '<div class="entry-summary"><p>' . $excerpt . '</p></div><!-- .entry-summary -->';
				} elseif ( 'full-content' === $show_content ) {
					$content = apply_filters( 'the_content', get_the_content() );
					$content = str_replace( ']]>', ']]&gt;', $content );
					echo '<div class="entry-content">' . wp_kses_post( $content ) . '</div><!-- .entry-content -->';
				} ?>
			</div><!-- .entry-container -->
		</div> <!-- .hentry-inner -->
	</article> <!-- .article -->
	<?php
endwhile;

wp_reset_postdata();
