<?php
/**
 * The template for displaying service content
 *
 * @package WEN_Travel
 */

$enable_content = get_theme_mod( 'wen_travel_service_option', 'disabled' );
$text_alignment = get_theme_mod( 'wen_travel_service_text_alignment', 'text-align-center' );

if ( ! wen_travel_check_section( $enable_content ) ) {
	// Bail if service content is disabled.
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_service_type', 'category' );

if ( 'ect-service' === $wen_travel_type ) {
	$wen_travel_title       = get_option( 'ect_service_title', esc_html__( 'Services', 'wen-travel-pro' ) );
	$wen_travel_description = get_option( 'ect_service_content' );
} else {
	$wen_travel_title       = get_theme_mod( 'wen_travel_service_title' );
	$wen_travel_description = get_theme_mod( 'wen_travel_service_description' );
}

$classes[] = 'service-section';
$classes[] = 'section';
$classes[] = $text_alignment;

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}
?>

<div id="service-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">
				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<?php

		$wrapper_classes[] = 'section-content-wrapper service-content-wrapper';

		$wrapper_classes[] = get_theme_mod( 'wen_travel_service_layout', 'layout-three' );
		?>

		<div class="<?php echo esc_attr( implode( ' ', $wrapper_classes ) ); ?>">
			<?php
			if ( 'custom' === $wen_travel_type ) {
				get_template_part( 'template-parts/service/content-custom' );
			} else {
				get_template_part( 'template-parts/service/content-service' );
			}
			?>

			<?php
				$target        = get_theme_mod( 'wen_travel_service_target' ) ? '_blank': '_self';
				$wen_travel_link = get_theme_mod( 'wen_travel_service_link', '#' );
				$text          = get_theme_mod( 'wen_travel_service_text' );

				if ( $text ) :
			?>

			<p class="view-more">
				<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
			</p>
			<?php endif; ?>
		</div><!-- .service-wrapper -->
	</div><!-- .wrapper -->
</div><!-- #service-section -->
