<?php
/**
  * The template used for displaying simage/custom lider
  *
  * @package WEN_Travel
  */

$quantity = get_theme_mod( 'wen_travel_slider_number', 4 );

$output = '';

for ( $i = 1; $i <= $quantity; $i++ ) {
	$image = get_theme_mod( 'wen_travel_slider_image_' . $i );

	// Check Image Not Empty to add in the slides.
	if ( $image ) {
		$imagetitle = get_theme_mod( 'wen_travel_slider_title_' . $i ) ? get_theme_mod( 'wen_travel_slider_title_' . $i ) : '';

		$wen_travel_title  = '';
		$wen_travel_link   = get_theme_mod( 'wen_travel_slider_link_' . $i );
		$target = get_theme_mod( 'wen_travel_slider_target_' . $i ) ? '_blank' : '_self';
		
		$wen_travel_title_image_html = '';

		$wen_travel_title = '<header class="entry-header"><h2 class="entry-title"><span class="title-image">' . $wen_travel_title_image_html . '</span><span class="title-text">' . esc_html( $imagetitle ) . '</span></h2></header>';

		if ( $wen_travel_link ) {
			$wen_travel_title = '<header class="entry-header"><h2 class="entry-title"><a title="' . esc_attr( $imagetitle ) . '" href="' . esc_url( $wen_travel_link ) . '" target="' . $target . '"><span class="title-image">' . $wen_travel_title_image_html . '</span><span class="title-text">' . esc_html( $imagetitle ) . '</span></a></h2></header>';
		}

		$content = get_theme_mod( 'wen_travel_slider_content_' . $i ) ? '<div class="entry-summary"><p>' . get_theme_mod( 'wen_travel_slider_content_' . $i ) . '</p></div><!-- .entry-summary -->' : '';

		$target        = get_theme_mod( 'wen_travel_slider_target_'. $i ) ? '_blank': '_self';
		$wen_travel_link = get_theme_mod( 'wen_travel_slider_link_' . $i, '#' );
		$text          = get_theme_mod( 'wen_travel_slider_text_' . $i );

		$button = '';

		if ( $text ) :

		$button = '
		<p>
			<a class="more-link" target="' . esc_attr( $target ) . '" href="' . esc_url( $wen_travel_link ) . '"> '. esc_html( $text ) . '
			</a>
		</p>';
		endif;

		$contentopening = '';
		$contentclosing = '';

		// Content Opening and Closing.
		if ( ! empty( $wen_travel_title ) || ! empty( $content ) ) {
			$contentopening = '<div class="slider-content-wrapper"><div class="entry-container">';
			$contentclosing = '</div><!-- .entry-container --></div><!-- .slider-content-wrapper -->';
		}
		
		$output .= '
		<article class="image-slides hentry slider-image images-' . esc_attr( $i ) . ' slides">
			<div class="hentry-inner">	
				<div class="slider-image-wrapper">
					<a href="' . esc_url( $wen_travel_link ) . '" title="' . esc_attr( $imagetitle ) . ' "target="' . $target . '">
						<img src="' . esc_url( $image ) . '" class="wp-post-image" alt="' . esc_attr( $imagetitle ) . '">
					</a>
				</div>
				' . $contentopening . $wen_travel_title . $content . $button . $contentclosing . '
			</div><!-- .hentry-inner -->	
		</article><!-- .slides -->';
	} // End if ().
} // End for().

echo $output;
