<?php
/**
 * The template used for displaying slider
 *
 * @package WEN_Travel
 */

$quantity      = get_theme_mod( 'wen_travel_slider_number', 4 );
$no_of_post    = 0; // for number of posts
$post_list     = array(); // list of valid post/page ids
$wen_travel_type = get_theme_mod( 'wen_travel_slider_type', 'category' );
$show_content  = get_theme_mod( 'wen_travel_slider_content_show', 'hide-content' );
$show_meta     = get_theme_mod( 'wen_travel_slider_meta_show', 'show-meta' );

$args = array(
	'post_type'           => 'any',
	'orderby'             => 'post__in',
	'ignore_sticky_posts' => 1, // ignore sticky posts
);
//Get valid number of posts
if ( 'post' === $wen_travel_type || 'page' === $wen_travel_type ) {
	for ( $i = 1; $i <= $quantity; $i++ ) {
		$wen_travel_post_id = '';

		if ( 'post' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_slider_post_' . $i );
		} elseif ( 'page' === $wen_travel_type ) {
			$wen_travel_post_id = get_theme_mod( 'wen_travel_slider_page_' . $i );
		}

		if ( $wen_travel_post_id && '' !== $wen_travel_post_id ) {
			$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

			$no_of_post++;
		}
	}

	$args['post__in'] = $post_list;
} elseif ( 'category' === $wen_travel_type ) {
	$no_of_post = $quantity;
	
	unset( $args['orderby'] );

	$args['category__in'] = get_theme_mod( 'wen_travel_slider_select_category' );

	$args['post_type'] = 'post';
} elseif ( 'tag' === $wen_travel_type ) {
	$no_of_post = $quantity;

	$args['tag__in'] = get_theme_mod( 'wen_travel_slider_select_tag' );

	$args['post_type'] = 'post';
}

if ( ! $no_of_post ) {
	return;
}

$args['posts_per_page'] = $no_of_post;

$loop = new WP_Query( $args );

while ( $loop->have_posts() ) :
	$loop->the_post();

	$thumbnail = 'wen-travel-slider';	
	?>
	<article class="<?php echo esc_attr( 'post post-' . get_the_ID() . ' hentry slides' ); ?>">
		<div class="hentry-inner">
			<div class="slider-image-wrapper">
				<a class="cover-link" title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>">
					<?php 
					if  ( has_post_thumbnail() ) {
						the_post_thumbnail( 'wen-travel-slider' );
					} else {
						echo '<img class="wp-post-image" src="' . trailingslashit( get_template_directory_uri() ) . 'images/no-thumb-1920x1080.jpg"/>';
					}
					?>
				</a>
			</div><!-- .slider-image-wrapper -->

			<div class="slider-content-wrapper">
				<div class="entry-container">
					<header class="entry-header">
						<?php 
						if ( 'show-meta' === $show_meta  && ( 'post' === $wen_travel_type || 'category' === $wen_travel_type || 'tag' === $wen_travel_type ) ) {
							echo wen_travel_slider_entry_category();
						}
						
						the_title( '<h2 class="entry-title"><a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>"><span class="title-text">','</span></a></h2>' );

						if ( 'show-meta' === $show_meta  && ( 'post' === $wen_travel_type || 'category' === $wen_travel_type || 'tag' === $wen_travel_type) ) {
							echo wen_travel_entry_date_author();
						}
						?>
					</header>

					<?php wen_travel_content_display( $show_content ); ?>
				</div><!-- .entry-container -->
			</div><!-- .slider-content-wrapper -->
		</div><!-- .hentry-inner -->
	</article><!-- .slides -->
<?php
endwhile;

wp_reset_postdata();
