<?php
/**
 * The template used for displaying Special Offer
 *
 * @package WEN_Travel
 */

$enable_section = get_theme_mod( 'wen_travel_special_offer_visibility', 'disabled' );

if ( ! wen_travel_check_section( $enable_section ) ) {
	// Bail if Special Offer is not enabled
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_special_offer_type', 'page' );

if ( 'page' === $wen_travel_type || 'post' === $wen_travel_type || 'category' === $wen_travel_type ) :
	get_template_part( 'template-parts/special-offer/post-type-special' );
else :
	get_template_part( 'template-parts/special-offer/custom-special' );
endif;
