<?php
/**
 * The template used for displaying Special Offer
 *
 * @package WEN_Travel
 */

$classes[] = 'special-offer-section';
$classes[] = 'section';
$classes[] = get_theme_mod( 'wen_travel_special_offer_img_align', 'content-align-left' );
$classes[] = get_theme_mod( 'wen_travel_special_offer_txt_align', 'text-align-left' );

$image     = get_theme_mod( 'wen_travel_special_offer_image' ); 

if ( ! $image ) {
	$classes[] = 'content-full-width';
}
?>
<div id="special-offer-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<div class="section-content-wrapper special-offer-content-wrapper">
			<article id="post-0" class="hentry<?php echo $image ? ' has-post-thumbnail' : ''; ?>">
				<div class="hentry-inner">
					<?php if ( $image ) : ?>
					<div class="thumb-video-wrapper">
						<?php if ( $image ) : ?>
							<div class="post-thumbnail">
	                            <?php
								$wen_travel_link = get_theme_mod( 'wen_travel_special_offer_link', '#' );
								$target        = get_theme_mod( 'wen_travel_special_offer_target' ) ? '_blank' : '_self';
	                            ?>

	                            <a class="cover-link" href="<?php echo esc_url( $wen_travel_link ); ?>" target="<?php echo esc_attr( $target ); ?>">
	                            	<img src="<?php echo esc_url( $image ); ?>">
	                            </a>
	                        </div><!-- .post-thumbnail -->
						<?php endif; ?>
					</div><!-- .thumb-video-wrapper -->
					<?php endif; ?>
					
					<div class="entry-container">
						<?php
						$wen_travel_title       = get_theme_mod( 'wen_travel_special_offer_title' );
						$wen_travel_description = get_theme_mod( 'wen_travel_special_offer_text' );
						$wen_travel_percent = get_theme_mod( 'wen_travel_special_offer_percentage' );
							$description_background = get_theme_mod( 'wen_travel_special_offer_text_bg_image' );

							$description_class = '';
							if ($description_background) {
								$description_class = 'has-bg-img';
							} 

						if ( $wen_travel_title ) : ?>
							<header class="entry-header">
								<h2 class="section-title">
									<?php echo wp_kses_post( $wen_travel_title ) ?>
								</h2>
							</header><!-- .entry-header -->
						<?php endif; ?>

						<?php if ( $wen_travel_description || $wen_travel_percent ) : ?>
							<div class="section-description <?php echo esc_attr( $description_class ); ?>">
								<p>
								<?php if ( $wen_travel_percent ) : ?>
									<span class="offer-percentage"><?php echo esc_html( absint( $wen_travel_percent ) ); ?>%</span>
								<?php endif; ?>
								
									<?php
									echo wp_kses_post( $wen_travel_description );
									?>
								</p>
							</div><!-- .section-description-wrapper -->
						<?php endif; ?>

						<?php if ( $content = get_theme_mod( 'wen_travel_special_offer_content' ) ) : ?>
						<div class="entry-content">
							<?php echo wp_kses_post( wpautop( $content ) ); ?>

							<?php
							$more_text   = get_theme_mod( 'wen_travel_special_offer_more_text' );
							$more_link   = get_theme_mod( 'wen_travel_special_offer_more_link', '#' );
							$more_target = get_theme_mod( 'wen_travel_special_offer_more_target' ) ? '_blank' : '_self' ;

							if ( $more_text ) : ?>
								<a class="more-link" href="<?php echo esc_url( $more_link ); ?>" target="<?php echo esc_attr( $more_target ); ?>">
									<span><?php echo esc_html( $more_text ); ?></span>
								</a>
							<?php
							endif;
							?>
						</div><!-- .entry-content -->
						<?php endif; ?>
					</div><!-- .entry-container -->
				</div><!-- .hentry-inner -->
			</article>
		</div><!-- .section-content-wrapper -->
	</div><!-- .wrapper -->
</div><!-- .section -->
