<?php
/**
 * The template for displaying stats image content
 *
 * @package WEN_Travel
 */
?>

<?php
$quantity = get_theme_mod( 'wen_travel_stats_number', 4 );
$bg_image 		 = get_theme_mod( 'wen_travel_stats_bg_image' );

$bg_image_class = '';

if ( $bg_image ) {
	$bg_image_class = 'has-bg-img';
}

for ( $i = 1; $i <= $quantity; $i++ ) {
	$target = get_theme_mod( 'wen_travel_stats_target_' . $i ) ? '_blank' : '_self';

	$wen_travel_link = get_theme_mod( 'wen_travel_stats_link_' . $i ) ? get_theme_mod( 'wen_travel_stats_link_' . $i ) : '#';

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	echo '
	<article id="stats-post-' . esc_attr( $i ) . '" class="hentry"> <div class="hentry-inner '. esc_attr( $bg_image_class ) .'">';

		$wen_travel_title = get_theme_mod( 'wen_travel_stats_title_' . $i );
		$content        = get_theme_mod( 'wen_travel_stats_content_' . $i );
		$more_button    = get_theme_mod( 'wen_travel_stats_more_button_text_' . $i );

		$image = get_theme_mod( 'wen_travel_stats_image_' . $i ) ? get_theme_mod( 'wen_travel_stats_image_' . $i ) : '';

		if ( $image ) {
			echo '
			<div class="post-thumbnail">
				<a href="' . esc_url( $wen_travel_link ) . '" target="' . esc_attr( $target ) . '">
					<img src="' . esc_url( $image ) . '" class="wp-post-image" alt="' . esc_attr( $wen_travel_title ) . '" title="' . esc_attr( $wen_travel_title ) . '">
				</a>
			</div>';
		}

		if ( $wen_travel_title || $content || $more_button) {
			echo '
			<div class="entry-container">';

				if ( $wen_travel_title ) {
					echo '
					<header class="entry-header">
					<h2 class="entry-title">
						<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . wp_kses_post( $wen_travel_title ) . '</a>
					</h2>';
					echo '</header>';
				}

				if ( $content || $more_button ) {
					if ( $more_button ) {
						$content .= '<p class="more-button">
							<a class="more-link" href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . esc_html( $more_button ) . '</a>
						</p>';
					}

				 	echo '<div class="entry-summary">' . wp_kses_post( apply_filters( 'the_content', $content ) ) . '</div><!-- .entry-summary -->';
				}



				echo '
			</div><!-- .entry-container -->';
		}

		echo '
		</div>
	</article><!-- .stats-post-' . esc_attr( $i ) . ' -->';
} // End for().
