<?php
/**
 * The template for displaying team content
 *
 * @package WEN_Travel
 */
?>

<?php
$enable_content = get_theme_mod( 'wen_travel_team_option', 'disabled' );

if ( ! wen_travel_check_section( $enable_content ) ) {
	// Bail if team content is disabled.
	return;
}

$wen_travel_type        = get_theme_mod( 'wen_travel_team_type', 'category' );
$wen_travel_title       = get_theme_mod( 'wen_travel_team_title' );
$wen_travel_description = get_theme_mod( 'wen_travel_team_description' );
$show_content           = get_theme_mod( 'wen_travel_team_show', 'hide-content' );
$show_meta              = get_theme_mod( 'wen_travel_team_meta_show', 'hide-meta' );
$layout                 = get_theme_mod( 'wen_travel_team_layout', 'layout-three' );

$classes[] = 'section';

if( ! $wen_travel_title && ! $wen_travel_description ) {
 	$classes[] = 'no-section-heading';
}

?>

<div id="team-content-section" class="team-content-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">
				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper team-content-wrapper <?php echo esc_attr( $layout ); ?>">
			<?php
			$number = get_theme_mod( 'wen_travel_team_number', 3 );
			
			if ( 'custom' === $wen_travel_type ) {
				$thumbnails = array();

				for ( $i = 1; $i <= $number; $i++ ) {
					$target = get_theme_mod( 'wen_travel_team_target_' . $i ) ? '_blank' : '_self';
					$image = get_theme_mod( 'wen_travel_team_image_' . $i ) ? get_theme_mod( 'wen_travel_team_image_' . $i ) : '';
					$wen_travel_link = get_theme_mod( 'wen_travel_team_link_' . $i ) ? get_theme_mod( 'wen_travel_team_link_' . $i ) : '#';

					if( has_post_thumbnail() ) {
						$thumbnails[] = $image;
					} else {
						$thumbnails[] = trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-260x260.jpg';
					}

					if ( function_exists( 'qtrans_convertURL' ) ) {
						$wen_travel_link = qtrans_convertURL( $wen_travel_link );
					}

					echo '
					<article id="team-post-' . esc_attr( $i ) . '" class="hentry"> <div class="hentry-inner">';

						$wen_travel_title = get_theme_mod( 'wen_travel_team_title_' . $i );
						$position         = get_theme_mod( 'wen_travel_team_position_' . $i );
						$content          = get_theme_mod( 'wen_travel_team_content_' . $i );
						$more_button      = get_theme_mod( 'wen_travel_team_more_button_text_' . $i );

						echo '
							<div class="post-thumbnail">
								<a href="' . esc_url( $wen_travel_link ) . '" target="' . esc_attr( $target ) . '">
									<img src="' . esc_url( $image ) . '" class="wp-post-image" alt="' . esc_attr( $wen_travel_title ) . '" title="' . esc_attr( $wen_travel_title ) . '">
								</a>
							</div>'; ?>

						<?php if ( $wen_travel_title || $content || $more_button) {
							echo '
							<div class="entry-container">
								<header class="entry-header">';

								if ( $wen_travel_title ) {
									echo '
									<h2 class="entry-title">
										<a href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . wp_kses_post( $wen_travel_title ) . '</a>
									</h2>';
								}

								if ( $position ) {
									echo '
									<div class="entry-meta">
										<span class="entry-job">
				                        	<span class="job-label">' . esc_html( $position ) . '</span>
					                    </span>
					                </div> <!-- .entry-meta -->';
					            }

								echo '</header>';

								if ( $content || $more_button ) {
									if ( $more_button ) {
										$content .= '<p>
											<a class="more-link" href="' . esc_url( $wen_travel_link ) . '" rel="bookmark" target="' . esc_attr( $target ) . '">' . esc_html( $more_button ) . '</a>
										</p>';
									}

								 	echo '<div class="entry-summary">' . wp_kses_post( apply_filters( 'the_content', $content ) ) . '</div><!-- .entry-summary -->';
								}

								wen_travel_team_social_links( $i );	

								echo '
							</div><!-- .entry-container -->';
						}

						echo '
						</div>
					</article><!-- .team-post-' . esc_attr( $i ) . ' -->';
				} // End for(). 
			} else {
				$post_list  = array();
				$no_of_post = 0;

				$args = array(
					'post_type'           => 'post',
					'ignore_sticky_posts' => 1, // ignore sticky posts.
				);

				// Get valid number of posts.
				if ( 'post' === $wen_travel_type || 'page' === $wen_travel_type || 'ect-team' === $wen_travel_type ) {
					$args['post_type'] = $wen_travel_type;

					for ( $i = 1; $i <= $number; $i++ ) {
						$wen_travel_post_id = '';

						if ( 'post' === $wen_travel_type ) {
							$wen_travel_post_id = get_theme_mod( 'wen_travel_team_post_' . $i );
						} elseif ( 'page' === $wen_travel_type ) {
							$wen_travel_post_id = get_theme_mod( 'wen_travel_team_page_' . $i );
						} elseif ( 'ect-team' === $wen_travel_type ) {
							$wen_travel_post_id = get_theme_mod( 'wen_travel_team_cpt_' . $i );
						}

						if ( $wen_travel_post_id && '' !== $wen_travel_post_id ) {
							$post_list = array_merge( $post_list, array( $wen_travel_post_id ) );

							$no_of_post++;
						}
					}

					$args['post__in'] = $post_list;
					$args['orderby']  = 'post__in';
				} elseif ( 'category' === $wen_travel_type ) {
					if ( $wen_travel_cat = get_theme_mod( 'wen_travel_team_select_category' ) ) {
						$args['category__in'] = $wen_travel_cat;
					}

					$no_of_post = $number;
				}

				$args['posts_per_page'] = $no_of_post;

				$thumbnails = array();
				
				$loop = new WP_Query( $args );

				if ( $loop -> have_posts() ) :
					while ( $loop -> have_posts() ) :
						$loop -> the_post();

						if( has_post_thumbnail() ) {
							$thumbnails[] = get_the_post_thumbnail_url( null, 'wen-travel-team' );
						} else {
							$thumbnails[] = trailingslashit( esc_url( get_template_directory_uri() ) ) . 'images/no-thumb-260x260.jpg';
						}

						?>
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<div class="hentry-inner">
								<?php wen_travel_post_thumbnail( array( 260, 260 ), 'html', true, true ); ?>

								<div class="entry-container">
									<header class="entry-header">
										<?php if ( 'show-meta' === $show_meta ) : ?>
										<div class="entry-meta">
											<?php wen_travel_cat_list(); ?>
										</div><!-- .entry-meta -->
										<?php endif; ?>

										<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">','</a></h2>' ); ?>
									</header>

									<?php wen_travel_content_display( $show_content ); ?>

									<?php wen_travel_team_social_links( absint( $loop->current_post ) + 1 ); ?>
								</div><!-- .entry-container -->
							</div> <!-- .hentry-inner -->
						</article> <!-- .article -->
						<?php
					endwhile;
					wp_reset_postdata();
				endif;
			}
			?>
		</div><!-- .team-wrapper -->
		
		<?php
			$target        = get_theme_mod( 'wen_travel_team_target' ) ? '_blank': '_self';
			$wen_travel_link = get_theme_mod( 'wen_travel_team_link', '#' );
			$text          = get_theme_mod( 'wen_travel_team_text' );

			if ( $text ) :
		?>

		<p class="view-more">
			<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
		</p>
		<?php endif; ?>

	</div><!-- .wrapper -->
</div><!-- #team-section -->
