<?php
/**
 * The template used for displaying testimonial on front page
 *
 * @package WEN_Travel
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="hentry-inner">
		<?php
		$show_content = get_theme_mod( 'wen_travel_testimonial_show', 'excerpt' ); ?>
		<div class="entry-container">
			<?php if ( 'excerpt' === $show_content  ) : ?>
				<div class="entry-content">
					<?php the_excerpt(); ?>
				</div>
			<?php elseif ( 'full-content' === $show_content ) : ?>
				<div class="entry-content">
					<?php the_content(); ?>
				</div>
			<?php endif; ?>

			<?php $position = get_post_meta( get_the_id(), 'ect_testimonial_position', true ); ?>
			
			<div class="author-thumb">
				<?php wen_travel_post_thumbnail( 'wen-travel-stats', 'html', true ); ?>
			
				<?php if ( get_theme_mod( 'wen_travel_testimonial_enable_title', 1 ) || $position ) : ?>
					<header class="entry-header">
						<?php if ( get_theme_mod( 'wen_travel_testimonial_enable_title', 1 ) ) {
							the_title( '<h2 class="entry-title">', '</h2>' );
							}
						?>
						<?php if ( $position ) : ?>
							<div class="entry-meta"><span class="position">
								<?php echo esc_html( $position ); ?></span>
							</div>
						<?php endif; ?>
					</header>
				</div> <!-- .author-thumb -->
			<?php endif;?>
		</div><!-- .entry-container -->	
	</div><!-- .hentry-inner -->
</article>
