<?php
/**
 * The template for displaying testimonial items
 *
 * @package WEN_Travel
 */
?>

<?php
$number = get_theme_mod( 'wen_travel_testimonial_number', 3 );

if ( ! $number ) {
	// If number is 0, then this section is disabled
	return;
}

for ( $i = 1; $i <= $number; $i++ ) {
	$content          = get_theme_mod( 'wen_travel_testimonial_content_' . $i );
	$target           = get_theme_mod( 'wen_travel_testimonial_target_' . $i ) ? '_blank': '_self';
	$wen_travel_link  = get_theme_mod( 'wen_travel_testimonial_link_' . $i, '#' );
	$wen_travel_title = get_theme_mod( 'wen_travel_testimonial_title_' . $i );
	$image            = get_theme_mod( 'wen_travel_testimonial_image_' . $i );
	$position         = get_theme_mod( 'wen_travel_testimonial_position_' . $i );

	if ( function_exists( 'qtrans_convertURL' ) ) {
		$wen_travel_link = qtrans_convertURL( $wen_travel_link );
	}

	?>

	<article id="post-<?php echo esc_attr( $i ) ?>" class="post hentry post-image has-post-thumbnail">
		<div class="hentry-inner">
			<div class="entry-container">
				<?php if ( $content ) : ?>
					<div class="entry-content">
						<?php echo wp_kses_post( wpautop( $content ) ); ?>
					</div>
				<?php endif; ?>

				<?php if ( $image ) : ?>
					<div class="testimonial-thumbnail post-thumbnail">
						<a target="<?php echo esc_attr( $target ); ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><img src="<?php echo esc_url( $image ); ?>" /></a>
					</div>
				<?php endif; ?>
			

				<?php if ( $wen_travel_title || $position ) : ?>
					<header class="entry-header">
						<?php if ( $wen_travel_title ): ?>
						<h2 class="entry-title"><a target="<?php echo esc_attr( $target ); ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo wp_kses_post( $wen_travel_title ); ?></a></h2>
						<?php endif; ?>

						<?php if ( $position ): ?>
						<div class="entry-meta"><span class="position"><?php echo esc_html( $position ); ?></span></div>
						<?php endif; ?>
					</header>
				<?php endif; ?>
			</div><!-- .entry-container -->
		</div><!-- .hentry-inner -->
	</article>
	<?php
}
