<?php
/**
 * The template for displaying testimonial items
 *
 * @package WEN_Travel
 */

$enable = get_theme_mod( 'wen_travel_testimonial_option', 'disabled' );

if ( ! wen_travel_check_section( $enable ) ) {
	// Bail if featured content is disabled
	return;
}

$wen_travel_type = get_theme_mod( 'wen_travel_testimonial_type', 'category' );

if ( 'jetpack-testimonial' === $wen_travel_type ) {
	// Get Jetpack options for testimonial.
	$jetpack_defaults = array(
		'page-title' => esc_html__( 'Testimonials', 'wen-travel-pro' ),
	);

	// Get Jetpack options for testimonial.
	$jetpack_options = get_theme_mod( 'jetpack_testimonials', $jetpack_defaults );

	$wen_travel_title       = isset( $jetpack_options['page-title'] ) ? $jetpack_options['page-title'] : esc_html__( 'Testimonials', 'wen-travel-pro' );
	$wen_travel_description = isset( $jetpack_options['page-content'] ) ? $jetpack_options['page-content'] : '';
} else {
	$wen_travel_title       = get_theme_mod( 'wen_travel_testimonial_title' );
	$wen_travel_description = get_theme_mod( 'wen_travel_testimonial_description' );
}

$classes[] = 'section testimonial-content-section';

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}
?>

<div id="testimonial-content-section" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<div class="full-content-wrap full-width">

			<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
				<div class="section-heading-wrapper">

					<?php if ( $wen_travel_title ) : ?>
						<div class="section-title-wrapper">
							<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
						</div><!-- .page-title-wrapper -->
					<?php endif; ?>

					<?php if ( $wen_travel_description ) : ?>
						<div class="section-description">
							<p>
								<?php
									echo wp_kses_post( $wen_travel_description );
								?>
							</p>
						</div><!-- .section-description-wrapper -->
					<?php endif; ?>
				</div><!-- .section-heading-wrapper -->
			<?php endif; ?>

			<?php 
			
			$content_classes = 'section-content-wrapper testimonial-content-wrapper';

			$content_classes .= ' testimonial-slider owl-carousel';

			if ( get_theme_mod( 'wen_travel_testimonial_dots', 1 ) ) {
				$content_classes .= ' owl-dots-enabled';
			} 
			?>

			<div class="<?php echo esc_attr( $content_classes ); ?>">
				<?php
				if ( 'post' === $wen_travel_type || 'jetpack-testimonial' === $wen_travel_type || 'page' === $wen_travel_type || 'category' === $wen_travel_type || 'tag' === $wen_travel_type ) {
					get_template_part( 'template-parts/testimonial/post-types-testimonial' );
				} elseif ( 'custom' === $wen_travel_type ) {
					get_template_part( 'template-parts/testimonial/custom-testimonial' );
				}
				?>
			</div><!-- .section-content-wrapper -->
		</div><!-- .full-content-wrap -->
	</div><!-- .wrapper -->
</div><!-- .testimonial-content-section -->
