<?php
/**
 * The template for displaying Woo Products Showcase
 *
 * @package WEN_Travel
 */

if ( ! class_exists( 'WooCommerce' ) ) {
    // Bail if WooCommerce is not installed
    return;
}

$enable_content = get_theme_mod( 'wen_travel_woo_products_showcase_option', 'disabled' );

if ( ! wen_travel_check_section( $enable_content ) ) {
	// Bail if featured content is disabled.
	return;
}

$number                = get_theme_mod( 'wen_travel_woo_products_showcase_number', 8 );
$columns               = get_theme_mod( 'wen_travel_woo_products_showcase_columns', 4 );
$paginate              = get_theme_mod( 'wen_travel_woo_products_showcase_paginate' );
$wen_travel_orderby = isset( $_GET['orderby'] ) ? $_GET['orderby'] : get_theme_mod( 'wen_travel_woo_products_showcase_orderby' );
$product_filter        = get_theme_mod( 'wen_travel_woo_products_showcase_products_filter' );
$featured              = get_theme_mod( 'wen_travel_woo_products_showcase_featured' );
$wen_travel_order   = get_theme_mod( 'wen_travel_woo_products_showcase_order' );
$skus                  = get_theme_mod( 'wen_travel_woo_products_showcase_skus' );
$category              = get_theme_mod( 'wen_travel_woo_products_showcase_category' );

$shortcode = '[products';

if ( $number ) {
	$shortcode .= ' limit="' . esc_attr( $number ) . '"';
}

if ( $columns ) {
	$shortcode .= ' columns="' . absint( $columns ) . '"';
}

if ( $paginate ) {
	$shortcode .= ' paginate="' . esc_attr( $paginate ) . '"';
}

if ( $wen_travel_orderby ) {
	$shortcode .= ' orderby="' . esc_attr( $wen_travel_orderby ) . '"';
}

if ( $wen_travel_order ) {
	$shortcode .= ' order="' . esc_attr( $wen_travel_order ) . '"';
}

if ( $product_filter && 'none' !== $product_filter ) {
	$shortcode .= ' ' . esc_attr( $product_filter ) . '="true"';
}

if ( $skus ) {
	$shortcode .= ' skus="' . esc_attr( $skus ) . '"';
}

if ( $category ) {
	$shortcode .= ' category="' . esc_attr( $category ) . '"';
}

if ( $featured ) {
	$shortcode .= ' visibility="featured"';
}

$shortcode .= ']';

$wen_travel_title       = get_theme_mod( 'wen_travel_woo_products_showcase_title' );
$wen_travel_description = get_theme_mod( 'wen_travel_woo_products_showcase_description' );
$classes[] = 'section';

if ( ! $wen_travel_title && ! $wen_travel_description ) {
	$classes[] = 'no-section-heading';
}
?>

<div id="product-content-section" class="product-content-section <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="wrapper">
		<?php if ( $wen_travel_title || $wen_travel_description ) : ?>
			<div class="section-heading-wrapper">
				<?php if ( $wen_travel_title ) : ?>
					<div class="section-title-wrapper">
						<h2 class="section-title"wen_travel_><?php echo wp_kses_post( $wen_travel_title ); ?></h2>
					</div><!-- .page-title-wrapper -->
				<?php endif; ?>

				<?php if ( $wen_travel_description ) : ?>
					<div class="section-description">
						<p>
							<?php
								echo wp_kses_post( $wen_travel_description );
							?>
						</p>
					</div><!-- .section-description-wrapper -->
				<?php endif; ?>
			</div><!-- .section-heading-wrapper -->
		<?php endif; ?>

		<div class="section-content-wrapper product-content-wrapper">
			<?php echo do_shortcode( $shortcode ); ?>
		</div><!-- .section-content-wrapper -->

		<?php
			$target = get_theme_mod( 'wen_travel_woo_products_showcase_target' ) ? '_blank': '_self';
			$wen_travel_link   = get_theme_mod( 'wen_travel_woo_products_showcase_link', get_permalink( wc_get_page_id( 'shop' ) ) );
			$text   = get_theme_mod( 'wen_travel_woo_products_showcase_text', esc_html__( 'Go to Shop Page', 'wen-travel-pro' ) );

			if ( $text ) :
		?>
			<p class="view-more">
				<a class="button" target="<?php echo $target; ?>" href="<?php echo esc_url( $wen_travel_link ); ?>"><?php echo esc_html( $text ); ?></a>
			</p>
		<?php endif; ?>
	</div><!-- .wrapper -->
</div><!-- .sectionr -->
